/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.message;

import filenet.sim.api.VWScenarioValidationError;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.message.images.VWImageLoader;
import filenet.vw.toolkit.design.message.resources.VWResource;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class VWSIMValidationErrorListCellRenderer
extends JLabel
implements ListCellRenderer {
    private ImageIcon m_errorIcon = null;
    private ImageIcon m_warningIcon = null;

    public VWSIMValidationErrorListCellRenderer() {
        try {
            this.setOpaque(true);
            this.m_errorIcon = VWImageLoader.createImageIcon("error.gif");
            this.m_warningIcon = VWImageLoader.createImageIcon("warning.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setFont(list.getFont());
        this.setEnabled(list.isEnabled());
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value != null && value instanceof VWScenarioValidationError) {
            VWScenarioValidationError error = (VWScenarioValidationError)value;
            ImageIcon icon = null;
            switch (error.getLevel()) {
                case 1: {
                    icon = this.m_errorIcon;
                    break;
                }
                case 2: {
                    icon = this.m_warningIcon;
                }
            }
            this.setIcon(icon);
            String name = error.getName();
            if (name == null || name.length() == 0) {
                name = VWResource.s_emptyName;
            }
            this.setText(name);
        } else if (value != null && value instanceof String) {
            this.setText((String)value);
            this.setToolTipText(null);
        }
        return this;
    }
}

